IF EXISTS
(
	SELECT *
	FROM sys.objects
	WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EXCLUIR]')
		  AND type IN(N'P', N'PC')
)
	DROP PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EXCLUIR];
GO
GO
--EXEC P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EXCLUIR 39
CREATE PROCEDURE P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EXCLUIR (@CD_CTR INT=0, @REAPLICAR INT=0)
AS
SET NOCOUNT ON;
CREATE TABLE #RsEstProd (CD_EMP INT, 
						 CD_PROD INT, 
						 CD_PERFIL_DEMOGRAFICO INT,
						 CD_PERFIL_TAMANHO INT,
						 CD_USU INT, 
						 DT_CAD DATETIME,
						 DT_ULT_ALT DATETIME)

CREATE TABLE #RsLoteProc (CD_CTR INT, CD_USU INT)
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PERFIL_TAMANHO INT
DECLARE @CD_PERFIL_DEMOGRAFICO INT
DECLARE @CD_USU INT

INSERT INTO #RsLoteProc
SELECT
	DISTINCT L.CD_CTR,
	L.CD_USU
FROM
	EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO L INNER JOIN EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD P ON
	L.CD_CTR = P.CD_CTR
WHERE
	L.STS_LOTE = CASE WHEN @REAPLICAR = 1 THEN L.STS_LOTE ELSE 0 END  
	AND L.CD_CTR = CASE WHEN @CD_CTR =0 THEN L.CD_CTR ELSE @CD_CTR END

INSERT INTO #RsEstProd
SELECT
	PR.CD_EMP,
	PR.CD_PROD,
	P.CD_PERFIL_DEMOGRAFICO,
	P.CD_PERFIL_TAMANHO,
	L.CD_USU,
	GETDATE(),
	NULL
FROM
	#RsLoteProc L INNER JOIN EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_PERFIL P ON
	L.CD_CTR = P.CD_CTR 
	INNER JOIN EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD PR ON
	L.CD_CTR = PR.CD_CTR 	

--Excluindo dados do produto
DELETE 
	P
FROM
	#RsEstProd pe INNER JOIN EST_PARAM_COMPRAS_PERFIL_EST_PROD p on
	pe.CD_EMP = p.CD_EMP AND
	pe.CD_PROD = p.CD_PROD AND
	pe.CD_PERFIL_DEMOGRAFICO=p.CD_PERFIL_DEMOGRAFICO AND
	pe.CD_PERFIL_TAMANHO=p.CD_PERFIL_TAMANHO

--Criando cursor para rodar por loja bloqueado
DECLARE ProcProdBlqExcluir CURSOR FAST_FORWARD FOR 
SELECT
	EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_EMP,
	EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_FILIAL,
	EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_PERFIL_TAMANHO,
	EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_PERFIL_DEMOGRAFICO,
	L.CD_USU
FROM
	#RsLoteProc L INNER JOIN EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_PERFIL P ON
	L.CD_CTR = P.CD_CTR 
	INNER JOIN EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL ON
	P.CD_PERFIL_TAMANHO = EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_PERFIL_TAMANHO AND
	P.CD_PERFIL_DEMOGRAFICO = EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_PERFIL_DEMOGRAFICO

OPEN ProcProdBlqExcluir;
FETCH NEXT FROM ProcProdBlqExcluir INTO
								@CD_EMP,
								@CD_FILIAL,
								@CD_PERFIL_TAMANHO,
								@CD_PERFIL_DEMOGRAFICO,
								@CD_USU;
WHILE @@FETCH_STATUS = 0
	BEGIN
	PRINT 'Filial bloqueando.: ' + CONVERT(CHAR(10), @CD_FILIAL, 112);
	--Atualizando bloqueio dos produtos nas lojas
	UPDATE
		EST_PROD_CPL
	SET 
		EST_PROD_CPL.STS_PROD=2,
		EST_PROD_CPL.CD_USU=@CD_USU,
		EST_PROD_CPL.DT_ULT_ATU = CONVERT(CHAR(10),GETDATE(),112)
	FROM
		EST_PROD_CPL LEFT OUTER JOIN EST_PARAM_COMPRAS_PERFIL_EST_PROD B ON
		EST_PROD_CPL.CD_EMP = b.CD_EMP AND
		EST_PROD_CPL.CD_FILIAL = @CD_FILIAL AND
		EST_PROD_CPL.CD_PROD = b.CD_PROD AND
		
		@CD_PERFIL_TAMANHO = b.CD_PERFIL_TAMANHO AND
		@CD_PERFIL_DEMOGRAFICO = b.CD_PERFIL_DEMOGRAFICO
	WHERE
		EST_PROD_CPL.CD_EMP=@CD_EMP
		AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
		AND EST_PROD_CPL.STS_PROD=0
		AND B.CD_PROD IS NULL

FETCH NEXT FROM ProcProdBlqExcluir INTO
								@CD_EMP,
								@CD_FILIAL,
								@CD_PERFIL_TAMANHO,
								@CD_PERFIL_DEMOGRAFICO,
								@CD_USU;
	END;

CLOSE ProcProdBlqExcluir;
DEALLOCATE ProcProdBlqExcluir;